define(function () {

    var component = {
        data: function () {
            return {};
        },
        computed: {
            webforsearch: function () {
                return this.webpartProperties.webforsearch;
            },
            resultSource: function () {
                return this.webpartProperties.resultSource;
            }
        },
        watch: {
            webforsearch: {
                handler: function () {
                    this.debouncedGetMustReadManuals();
                },
                deep: true
            },
            resultSource: {
                handler: function () {
                    this.debouncedGetMustReadManuals();
                },
                deep: true
            }
        },
        methods: {
            debouncedGetMustReadManuals: _.debounce(function () {
                this.getMustReadManuals();
            }, 2000)
        },
        created: function () {
            this.getMustReadManuals();
        }
    };

    component.originalTemplate = "pagesIMustRead.list";
    component.template = `
<wizdomWebpart data-v-6af5541f
  v-if="manualData.manualPages"
  :environmentInfo="environmentInfo"
  :chromeProperties="webpartProperties.chromeProperties"
  :dynamicData="manualData.manualPages.length"
  :title="'Pages I must read' | translate"
  @titleChanged="webpartProperties.title = $event"
  :webpartPadding="true"
  chromeType="title"
  @webpart-resize="webpartResize"
>
  <div data-v-6af5541f class="container">
    <div data-v-6af5541f class="ms-Grid revert-Padding">
      <div data-v-6af5541f class="ms-Grid-row header-container">
        <div data-v-6af5541f class="ms-Grid-col ms-md4 title-padding header-table">{{ 'Title' | translate}}</div>
        <div data-v-6af5541f class="ms-Grid-col ms-md1 header-table xxs-hidden"></div>
        <div data-v-6af5541f
          class="ms-Grid-col ms-md2 title-padding header-table xxs-hidden"
        >{{ 'Version' | translate}}</div>
        <div data-v-6af5541f class="ms-Grid-col ms-md1 header-table xxs-hidden"></div>
        <div data-v-6af5541f
          class="ms-Grid-col ms-md4 title-padding header-table xxs-hidden"
        >{{ 'Date' | translate}}</div>
      </div>

      <div data-v-6af5541f class="ms-Grid-row list-container">
        <div data-v-6af5541f class="ms-Grid-col ms-md12">
          <div data-v-6af5541f
            class="ms-Grid-row content-table"
            v-for="(page) in slicePage(currentPage, pagesize)"
            :key="page.id"
          >
            <div data-v-6af5541f class="ms-Grid-col ms-md4 line-height-modifier word-break">
              <a data-v-6af5541f v-if="page.title" :href="page.path">{{page.title}}</a>
              <a data-v-6af5541f v-else :href="page.path">{{"No title" | translate}}</a>
            </div>
            <div data-v-6af5541f class="ms-Grid-col ms-md1 header-table xxs-hidden"></div>
            <div data-v-6af5541f class="ms-Grid-col ms-md2 line-height-modifier xxs-hidden">{{page.pageVersion}}</div>
            <div data-v-6af5541f class="ms-Grid-col ms-md1 header-table xxs-hidden"></div>
            <div data-v-6af5541f
              class="ms-Grid-col ms-md4 line-height-modifier xxs-hidden"
            >{{page.modifiedDate.substring(0,10)}}</div>
          </div>
        </div>
        <div data-v-6af5541f v-if="!manualData.manualPages" class="ms-Grid-col ms-md12">
          <div data-v-6af5541f class="ms-Grid-row content-table">
            <div data-v-6af5541f
              class="ms-Grid-col line-height-modifier"
            >{{"You have read all required pages!" | translate}}</div>
          </div>
        </div>
      </div>
    </div>
    <!-- Pagination -->
    <pagination data-v-6af5541f
      class="pagination"
      v-if="manualData && manualData.manualPages.length > pagesize"
      :pageSize="pagesize"
      :length="manualData.manualPages.length"
      :align="'center'"
      :webpartSize="webpartSize"
      @onPageChanged="pageChanged"
      v-model="currentPage"
    ></pagination>
  </div>
</wizdomWebpart>
`;
    component.styles = `
/* themed tokens */
/*
  Your use of the content in the files referenced here is subject to the terms of the license at http://aka.ms/fabric-assets-license
*/
/**
 * Partials that output CSS
 */
@font-face {
  font-family: "Leelawadee UI Web";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/leelawadeeui-thai/leelawadeeui-light.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/leelawadeeui-thai/leelawadeeui-light.woff") format("woff");
  font-weight: 100;
  font-style: normal;
}
@font-face {
  font-family: "Leelawadee UI Web";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/leelawadeeui-thai/leelawadeeui-semilight.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/leelawadeeui-thai/leelawadeeui-semilight.woff") format("woff");
  font-weight: 300;
  font-style: normal;
}
@font-face {
  font-family: "Leelawadee UI Web";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/leelawadeeui-thai/leelawadeeui-regular.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/leelawadeeui-thai/leelawadeeui-regular.woff") format("woff");
  font-weight: 400;
  font-style: normal;
}
@font-face {
  font-family: "Leelawadee UI Web";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/leelawadeeui-thai/leelawadeeui-semibold.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/leelawadeeui-thai/leelawadeeui-semibold.woff") format("woff");
  font-weight: 600;
  font-style: normal;
}
@font-face {
  font-family: "Leelawadee UI Web";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/leelawadeeui-thai/leelawadeeui-bold.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/leelawadeeui-thai/leelawadeeui-bold.woff") format("woff");
  font-weight: 700;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (Arabic)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-arabic/segoeui-light.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-arabic/segoeui-light.woff") format("woff");
  font-weight: 100;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (Arabic)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-arabic/segoeui-semilight.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-arabic/segoeui-semilight.woff") format("woff");
  font-weight: 300;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (Arabic)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-arabic/segoeui-regular.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-arabic/segoeui-regular.woff") format("woff");
  font-weight: 400;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (Arabic)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-arabic/segoeui-semibold.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-arabic/segoeui-semibold.woff") format("woff");
  font-weight: 600;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (Arabic)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-arabic/segoeui-bold.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-arabic/segoeui-bold.woff") format("woff");
  font-weight: 700;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (Cyrillic)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-cyrillic/segoeui-light.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-cyrillic/segoeui-light.woff") format("woff");
  font-weight: 100;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (Cyrillic)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-cyrillic/segoeui-semilight.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-cyrillic/segoeui-semilight.woff") format("woff");
  font-weight: 300;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (Cyrillic)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-cyrillic/segoeui-regular.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-cyrillic/segoeui-regular.woff") format("woff");
  font-weight: 400;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (Cyrillic)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-cyrillic/segoeui-semibold.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-cyrillic/segoeui-semibold.woff") format("woff");
  font-weight: 600;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (Cyrillic)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-cyrillic/segoeui-bold.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-cyrillic/segoeui-bold.woff") format("woff");
  font-weight: 700;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (East European)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-easteuropean/segoeui-light.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-easteuropean/segoeui-light.woff") format("woff");
  font-weight: 100;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (East European)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-easteuropean/segoeui-semilight.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-easteuropean/segoeui-semilight.woff") format("woff");
  font-weight: 300;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (East European)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-easteuropean/segoeui-regular.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-easteuropean/segoeui-regular.woff") format("woff");
  font-weight: 400;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (East European)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-easteuropean/segoeui-semibold.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-easteuropean/segoeui-semibold.woff") format("woff");
  font-weight: 600;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (East European)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-easteuropean/segoeui-bold.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-easteuropean/segoeui-bold.woff") format("woff");
  font-weight: 700;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (Greek)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-greek/segoeui-light.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-greek/segoeui-light.woff") format("woff");
  font-weight: 100;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (Greek)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-greek/segoeui-semilight.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-greek/segoeui-semilight.woff") format("woff");
  font-weight: 300;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (Greek)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-greek/segoeui-regular.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-greek/segoeui-regular.woff") format("woff");
  font-weight: 400;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (Greek)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-greek/segoeui-semibold.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-greek/segoeui-semibold.woff") format("woff");
  font-weight: 600;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (Greek)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-greek/segoeui-bold.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-greek/segoeui-bold.woff") format("woff");
  font-weight: 700;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (Hebrew)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-hebrew/segoeui-light.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-hebrew/segoeui-light.woff") format("woff");
  font-weight: 100;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (Hebrew)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-hebrew/segoeui-semilight.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-hebrew/segoeui-semilight.woff") format("woff");
  font-weight: 300;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (Hebrew)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-hebrew/segoeui-regular.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-hebrew/segoeui-regular.woff") format("woff");
  font-weight: 400;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (Hebrew)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-hebrew/segoeui-semibold.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-hebrew/segoeui-semibold.woff") format("woff");
  font-weight: 600;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (Hebrew)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-hebrew/segoeui-bold.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-hebrew/segoeui-bold.woff") format("woff");
  font-weight: 700;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (Vietnamese)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-vietnamese/segoeui-light.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-vietnamese/segoeui-light.woff") format("woff");
  font-weight: 100;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (Vietnamese)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-vietnamese/segoeui-semilight.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-vietnamese/segoeui-semilight.woff") format("woff");
  font-weight: 300;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (Vietnamese)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-vietnamese/segoeui-regular.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-vietnamese/segoeui-regular.woff") format("woff");
  font-weight: 400;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (Vietnamese)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-vietnamese/segoeui-semibold.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-vietnamese/segoeui-semibold.woff") format("woff");
  font-weight: 600;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (Vietnamese)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-vietnamese/segoeui-bold.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-vietnamese/segoeui-bold.woff") format("woff");
  font-weight: 700;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (West European)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-westeuropean/segoeui-light.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-westeuropean/segoeui-light.woff") format("woff");
  font-weight: 100;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (West European)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-westeuropean/segoeui-semilight.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-westeuropean/segoeui-semilight.woff") format("woff");
  font-weight: 300;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (West European)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-westeuropean/segoeui-regular.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-westeuropean/segoeui-regular.woff") format("woff");
  font-weight: 400;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (West European)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-westeuropean/segoeui-semibold.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-westeuropean/segoeui-semibold.woff") format("woff");
  font-weight: 600;
  font-style: normal;
}
@font-face {
  font-family: "Segoe UI Web (West European)";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-westeuropean/segoeui-bold.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/segoeui-westeuropean/segoeui-bold.woff") format("woff");
  font-weight: 700;
  font-style: normal;
}
@font-face {
  font-family: "Selawik Web";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/selawik/selawik-light.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/selawik/selawik-light.woff") format("woff");
  font-weight: 100;
  font-style: normal;
}
@font-face {
  font-family: "Selawik Web";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/selawik/selawik-semilight.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/selawik/selawik-semilight.woff") format("woff");
  font-weight: 300;
  font-style: normal;
}
@font-face {
  font-family: "Selawik Web";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/selawik/selawik-regular.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/selawik/selawik-regular.woff") format("woff");
  font-weight: 400;
  font-style: normal;
}
@font-face {
  font-family: "Selawik Web";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/selawik/selawik-semibold.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/selawik/selawik-semibold.woff") format("woff");
  font-weight: 600;
  font-style: normal;
}
@font-face {
  font-family: "Selawik Web";
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/selawik/selawik-bold.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/selawik/selawik-bold.woff") format("woff");
  font-weight: 700;
  font-style: normal;
}
@font-face {
  font-family: 'Leelawadee UI Web';
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/leelawadeeui-thai/leelawadeeui-semilight.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/leelawadeeui-thai/leelawadeeui-semilight.woff") format("woff");
  font-weight: 100;
  font-style: normal;
}
@font-face {
  font-family: 'Leelawadee UI Web';
  src: url("https://static2.sharepointonline.com/files/fabric/assets/fonts/leelawadeeui-thai/leelawadeeui-bold.woff2") format("woff2"), url("https://static2.sharepointonline.com/files/fabric/assets/fonts/leelawadeeui-thai/leelawadeeui-bold.woff") format("woff");
  font-weight: 600;
  font-style: normal;
}
.ms-fontSize-68[data-v-6af5541f] {
  font-size: 68px;
}
.ms-fontSize-42[data-v-6af5541f] {
  font-size: 42px;
}
.ms-fontSize-32[data-v-6af5541f] {
  font-size: 32px;
}
.ms-fontSize-28[data-v-6af5541f] {
  font-size: 28px;
}
.ms-fontSize-24[data-v-6af5541f] {
  font-size: 24px;
}
.ms-fontSize-20[data-v-6af5541f] {
  font-size: 20px;
}
.ms-fontSize-18[data-v-6af5541f] {
  font-size: 18px;
}
.ms-fontSize-16[data-v-6af5541f] {
  font-size: 16px;
}
.ms-fontSize-14[data-v-6af5541f] {
  font-size: 14px;
}
.ms-fontSize-12[data-v-6af5541f] {
  font-size: 12px;
}
.ms-fontSize-10[data-v-6af5541f] {
  font-size: 10px;
}
.ms-fontWeight-regular[data-v-6af5541f] {
  font-weight: 400;
}
.ms-fontWeight-semibold[data-v-6af5541f] {
  font-weight: 600;
}
.ms-fontWeight-bold[data-v-6af5541f] {
  font-weight: 700;
}
.ms-font-su[data-v-6af5541f] {
  font-size: 42px;
  font-weight: 100;
}
.ms-font-xxl[data-v-6af5541f] {
  font-size: 28px;
  font-weight: 100;
}
.ms-font-xl-plus[data-v-6af5541f] {
  font-size: 24px;
  font-weight: 100;
}
.ms-font-xl[data-v-6af5541f] {
  font-size: 21px;
  font-weight: 100;
}
.ms-font-l[data-v-6af5541f] {
  font-size: 17px;
  font-weight: 300;
}
.ms-font-m-plus[data-v-6af5541f] {
  font-size: 15px;
  font-weight: 400;
}
.ms-font-m[data-v-6af5541f] {
  font-size: 14px;
  font-weight: 400;
}
.ms-font-s-plus[data-v-6af5541f] {
  font-size: 13px;
  font-weight: 400;
}
.ms-font-s[data-v-6af5541f] {
  font-size: 12px;
  font-weight: 400;
}
.ms-font-xs[data-v-6af5541f] {
  font-size: 11px;
  font-weight: 400;
}
.ms-font-mi[data-v-6af5541f] {
  font-size: 10px;
  font-weight: 600;
}
.ms-fontWeight-light[data-v-6af5541f] {
  font-weight: 100;
}
.ms-fontWeight-semilight[data-v-6af5541f] {
  font-weight: 300;
}
.ms-fontSize-su[data-v-6af5541f] {
  font-size: 42px;
}
.ms-fontSize-xxl[data-v-6af5541f] {
  font-size: 28px;
}
.ms-fontSize-xlPlus[data-v-6af5541f] {
  font-size: 24px;
}
.ms-fontSize-xl[data-v-6af5541f] {
  font-size: 21px;
}
.ms-fontSize-l[data-v-6af5541f] {
  font-size: 17px;
}
.ms-fontSize-mPlus[data-v-6af5541f] {
  font-size: 15px;
}
.ms-fontSize-m[data-v-6af5541f] {
  font-size: 14px;
}
.ms-fontSize-sPlus[data-v-6af5541f] {
  font-size: 13px;
}
.ms-fontSize-s[data-v-6af5541f] {
  font-size: 12px;
}
.ms-fontSize-xs[data-v-6af5541f] {
  font-size: 11px;
}
.ms-fontSize-mi[data-v-6af5541f] {
  font-size: 10px;
}
.ms-Grid[data-v-6af5541f] {
  box-sizing: border-box;
  *zoom: 1;
  padding: 0 8px;
}
.ms-Grid[data-v-6af5541f]::before, .ms-Grid[data-v-6af5541f]::after {
    display: table;
    content: '';
    line-height: 0;
}
.ms-Grid[data-v-6af5541f]::after {
    clear: both;
}
.ms-Grid-row[data-v-6af5541f] {
  margin: 0 -8px;
  box-sizing: border-box;
  *zoom: 1;
}
.ms-Grid-row[data-v-6af5541f]::before, .ms-Grid-row[data-v-6af5541f]::after {
    display: table;
    content: '';
    line-height: 0;
}
.ms-Grid-row[data-v-6af5541f]::after {
    clear: both;
}
.ms-Grid-col[data-v-6af5541f] {
  position: relative;
  min-height: 1px;
  padding-left: 8px;
  padding-right: 8px;
  box-sizing: border-box;
}
[dir='ltr'] .ms-Grid-col[data-v-6af5541f] {
    float: left;
}
[dir='rtl'] .ms-Grid-col[data-v-6af5541f] {
    float: right;
}
.ms-Grid-col .ms-Grid[data-v-6af5541f] {
    padding: 0;
}
@media (max-width: 479.99999px) {
.ms-hiddenSm[data-v-6af5541f],
  .ms-hiddenMdDown[data-v-6af5541f],
  .ms-hiddenLgDown[data-v-6af5541f],
  .ms-hiddenXlDown[data-v-6af5541f],
  .ms-hiddenXxlDown[data-v-6af5541f] {
    display: none !important;
}
}
@media (min-width: 480px) and (max-width: 639.99999px) {
.ms-hiddenMd[data-v-6af5541f],
  .ms-hiddenMdUp[data-v-6af5541f],
  .ms-hiddenMdDown[data-v-6af5541f],
  .ms-hiddenLgDown[data-v-6af5541f],
  .ms-hiddenXlDown[data-v-6af5541f],
  .ms-hiddenXxlDown[data-v-6af5541f] {
    display: none !important;
}
}
@media (min-width: 640px) and (max-width: 1023.99999px) {
.ms-hiddenMdUp[data-v-6af5541f],
  .ms-hiddenLg[data-v-6af5541f],
  .ms-hiddenLgUp[data-v-6af5541f],
  .ms-hiddenLgDown[data-v-6af5541f],
  .ms-hiddenXlDown[data-v-6af5541f],
  .ms-hiddenXxlDown[data-v-6af5541f] {
    display: none !important;
}
}
@media (min-width: 1024px) and (max-width: 1365.99999px) {
.ms-hiddenMdUp[data-v-6af5541f],
  .ms-hiddenLgUp[data-v-6af5541f],
  .ms-hiddenXl[data-v-6af5541f],
  .ms-hiddenXlUp[data-v-6af5541f],
  .ms-hiddenXlDown[data-v-6af5541f],
  .ms-hiddenXxlDown[data-v-6af5541f] {
    display: none !important;
}
}
@media (min-width: 1366px) and (max-width: 1919.99999px) {
.ms-hiddenMdUp[data-v-6af5541f],
  .ms-hiddenLgUp[data-v-6af5541f],
  .ms-hiddenXlUp[data-v-6af5541f],
  .ms-hiddenXxl[data-v-6af5541f],
  .ms-hiddenXxlUp[data-v-6af5541f],
  .ms-hiddenXxlDown[data-v-6af5541f] {
    display: none !important;
}
}
@media (min-width: 1920px) {
.ms-hiddenMdUp[data-v-6af5541f],
  .ms-hiddenLgUp[data-v-6af5541f],
  .ms-hiddenXlUp[data-v-6af5541f],
  .ms-hiddenXxlUp[data-v-6af5541f],
  .ms-hiddenXxxl[data-v-6af5541f] {
    display: none !important;
}
}
.ms-sm12[data-v-6af5541f] {
  width: 100%;
}
.ms-sm11[data-v-6af5541f] {
  width: 91.66666666666666%;
}
.ms-sm10[data-v-6af5541f] {
  width: 83.33333333333334%;
}
.ms-sm9[data-v-6af5541f] {
  width: 75%;
}
.ms-sm8[data-v-6af5541f] {
  width: 66.66666666666666%;
}
.ms-sm7[data-v-6af5541f] {
  width: 58.333333333333336%;
}
.ms-sm6[data-v-6af5541f] {
  width: 50%;
}
.ms-sm5[data-v-6af5541f] {
  width: 41.66666666666667%;
}
.ms-sm4[data-v-6af5541f] {
  width: 33.33333333333333%;
}
.ms-sm3[data-v-6af5541f] {
  width: 25%;
}
.ms-sm2[data-v-6af5541f] {
  width: 16.666666666666664%;
}
.ms-sm1[data-v-6af5541f] {
  width: 8.333333333333332%;
}
[dir='ltr'] .ms-smPull12[data-v-6af5541f] {
  right: 100%;
}
[dir='rtl'] .ms-smPull12[data-v-6af5541f] {
  left: 100%;
}
[dir='ltr'] .ms-smPull11[data-v-6af5541f] {
  right: 91.66667%;
}
[dir='rtl'] .ms-smPull11[data-v-6af5541f] {
  left: 91.66667%;
}
[dir='ltr'] .ms-smPull10[data-v-6af5541f] {
  right: 83.33333%;
}
[dir='rtl'] .ms-smPull10[data-v-6af5541f] {
  left: 83.33333%;
}
[dir='ltr'] .ms-smPull9[data-v-6af5541f] {
  right: 75%;
}
[dir='rtl'] .ms-smPull9[data-v-6af5541f] {
  left: 75%;
}
[dir='ltr'] .ms-smPull8[data-v-6af5541f] {
  right: 66.66667%;
}
[dir='rtl'] .ms-smPull8[data-v-6af5541f] {
  left: 66.66667%;
}
[dir='ltr'] .ms-smPull7[data-v-6af5541f] {
  right: 58.33333%;
}
[dir='rtl'] .ms-smPull7[data-v-6af5541f] {
  left: 58.33333%;
}
[dir='ltr'] .ms-smPull6[data-v-6af5541f] {
  right: 50%;
}
[dir='rtl'] .ms-smPull6[data-v-6af5541f] {
  left: 50%;
}
[dir='ltr'] .ms-smPull5[data-v-6af5541f] {
  right: 41.66667%;
}
[dir='rtl'] .ms-smPull5[data-v-6af5541f] {
  left: 41.66667%;
}
[dir='ltr'] .ms-smPull4[data-v-6af5541f] {
  right: 33.33333%;
}
[dir='rtl'] .ms-smPull4[data-v-6af5541f] {
  left: 33.33333%;
}
[dir='ltr'] .ms-smPull3[data-v-6af5541f] {
  right: 25%;
}
[dir='rtl'] .ms-smPull3[data-v-6af5541f] {
  left: 25%;
}
[dir='ltr'] .ms-smPull2[data-v-6af5541f] {
  right: 16.66667%;
}
[dir='rtl'] .ms-smPull2[data-v-6af5541f] {
  left: 16.66667%;
}
[dir='ltr'] .ms-smPull1[data-v-6af5541f] {
  right: 8.33333%;
}
[dir='rtl'] .ms-smPull1[data-v-6af5541f] {
  left: 8.33333%;
}
[dir='ltr'] .ms-smPull0[data-v-6af5541f] {
  right: auto;
}
[dir='rtl'] .ms-smPull0[data-v-6af5541f] {
  left: auto;
}
[dir='ltr'] .ms-smPush12[data-v-6af5541f] {
  left: 100%;
}
[dir='rtl'] .ms-smPush12[data-v-6af5541f] {
  right: 100%;
}
[dir='ltr'] .ms-smPush11[data-v-6af5541f] {
  left: 91.66667%;
}
[dir='rtl'] .ms-smPush11[data-v-6af5541f] {
  right: 91.66667%;
}
[dir='ltr'] .ms-smPush10[data-v-6af5541f] {
  left: 83.33333%;
}
[dir='rtl'] .ms-smPush10[data-v-6af5541f] {
  right: 83.33333%;
}
[dir='ltr'] .ms-smPush9[data-v-6af5541f] {
  left: 75%;
}
[dir='rtl'] .ms-smPush9[data-v-6af5541f] {
  right: 75%;
}
[dir='ltr'] .ms-smPush8[data-v-6af5541f] {
  left: 66.66667%;
}
[dir='rtl'] .ms-smPush8[data-v-6af5541f] {
  right: 66.66667%;
}
[dir='ltr'] .ms-smPush7[data-v-6af5541f] {
  left: 58.33333%;
}
[dir='rtl'] .ms-smPush7[data-v-6af5541f] {
  right: 58.33333%;
}
[dir='ltr'] .ms-smPush6[data-v-6af5541f] {
  left: 50%;
}
[dir='rtl'] .ms-smPush6[data-v-6af5541f] {
  right: 50%;
}
[dir='ltr'] .ms-smPush5[data-v-6af5541f] {
  left: 41.66667%;
}
[dir='rtl'] .ms-smPush5[data-v-6af5541f] {
  right: 41.66667%;
}
[dir='ltr'] .ms-smPush4[data-v-6af5541f] {
  left: 33.33333%;
}
[dir='rtl'] .ms-smPush4[data-v-6af5541f] {
  right: 33.33333%;
}
[dir='ltr'] .ms-smPush3[data-v-6af5541f] {
  left: 25%;
}
[dir='rtl'] .ms-smPush3[data-v-6af5541f] {
  right: 25%;
}
[dir='ltr'] .ms-smPush2[data-v-6af5541f] {
  left: 16.66667%;
}
[dir='rtl'] .ms-smPush2[data-v-6af5541f] {
  right: 16.66667%;
}
[dir='ltr'] .ms-smPush1[data-v-6af5541f] {
  left: 8.33333%;
}
[dir='rtl'] .ms-smPush1[data-v-6af5541f] {
  right: 8.33333%;
}
[dir='ltr'] .ms-smPush0[data-v-6af5541f] {
  left: auto;
}
[dir='rtl'] .ms-smPush0[data-v-6af5541f] {
  right: auto;
}
[dir='ltr'] .ms-smOffset11[data-v-6af5541f] {
  margin-left: 91.66667%;
}
[dir='rtl'] .ms-smOffset11[data-v-6af5541f] {
  margin-right: 91.66667%;
}
[dir='ltr'] .ms-smOffset10[data-v-6af5541f] {
  margin-left: 83.33333%;
}
[dir='rtl'] .ms-smOffset10[data-v-6af5541f] {
  margin-right: 83.33333%;
}
[dir='ltr'] .ms-smOffset9[data-v-6af5541f] {
  margin-left: 75%;
}
[dir='rtl'] .ms-smOffset9[data-v-6af5541f] {
  margin-right: 75%;
}
[dir='ltr'] .ms-smOffset8[data-v-6af5541f] {
  margin-left: 66.66667%;
}
[dir='rtl'] .ms-smOffset8[data-v-6af5541f] {
  margin-right: 66.66667%;
}
[dir='ltr'] .ms-smOffset7[data-v-6af5541f] {
  margin-left: 58.33333%;
}
[dir='rtl'] .ms-smOffset7[data-v-6af5541f] {
  margin-right: 58.33333%;
}
[dir='ltr'] .ms-smOffset6[data-v-6af5541f] {
  margin-left: 50%;
}
[dir='rtl'] .ms-smOffset6[data-v-6af5541f] {
  margin-right: 50%;
}
[dir='ltr'] .ms-smOffset5[data-v-6af5541f] {
  margin-left: 41.66667%;
}
[dir='rtl'] .ms-smOffset5[data-v-6af5541f] {
  margin-right: 41.66667%;
}
[dir='ltr'] .ms-smOffset4[data-v-6af5541f] {
  margin-left: 33.33333%;
}
[dir='rtl'] .ms-smOffset4[data-v-6af5541f] {
  margin-right: 33.33333%;
}
[dir='ltr'] .ms-smOffset3[data-v-6af5541f] {
  margin-left: 25%;
}
[dir='rtl'] .ms-smOffset3[data-v-6af5541f] {
  margin-right: 25%;
}
[dir='ltr'] .ms-smOffset2[data-v-6af5541f] {
  margin-left: 16.66667%;
}
[dir='rtl'] .ms-smOffset2[data-v-6af5541f] {
  margin-right: 16.66667%;
}
[dir='ltr'] .ms-smOffset1[data-v-6af5541f] {
  margin-left: 8.33333%;
}
[dir='rtl'] .ms-smOffset1[data-v-6af5541f] {
  margin-right: 8.33333%;
}
[dir='ltr'] .ms-smOffset0[data-v-6af5541f] {
  margin-left: 0;
}
[dir='rtl'] .ms-smOffset0[data-v-6af5541f] {
  margin-right: 0;
}
@media (min-width: 480px) {
.ms-md12[data-v-6af5541f] {
    width: 100%;
}
}
@media (min-width: 480px) {
.ms-md11[data-v-6af5541f] {
    width: 91.66666666666666%;
}
}
@media (min-width: 480px) {
.ms-md10[data-v-6af5541f] {
    width: 83.33333333333334%;
}
}
@media (min-width: 480px) {
.ms-md9[data-v-6af5541f] {
    width: 75%;
}
}
@media (min-width: 480px) {
.ms-md8[data-v-6af5541f] {
    width: 66.66666666666666%;
}
}
@media (min-width: 480px) {
.ms-md7[data-v-6af5541f] {
    width: 58.333333333333336%;
}
}
@media (min-width: 480px) {
.ms-md6[data-v-6af5541f] {
    width: 50%;
}
}
@media (min-width: 480px) {
.ms-md5[data-v-6af5541f] {
    width: 41.66666666666667%;
}
}
@media (min-width: 480px) {
.ms-md4[data-v-6af5541f] {
    width: 33.33333333333333%;
}
}
@media (min-width: 480px) {
.ms-md3[data-v-6af5541f] {
    width: 25%;
}
}
@media (min-width: 480px) {
.ms-md2[data-v-6af5541f] {
    width: 16.666666666666664%;
}
}
@media (min-width: 480px) {
.ms-md1[data-v-6af5541f] {
    width: 8.333333333333332%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdPull12[data-v-6af5541f] {
    right: 100%;
}
[dir='rtl'] .ms-mdPull12[data-v-6af5541f] {
    left: 100%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdPull11[data-v-6af5541f] {
    right: 91.66667%;
}
[dir='rtl'] .ms-mdPull11[data-v-6af5541f] {
    left: 91.66667%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdPull10[data-v-6af5541f] {
    right: 83.33333%;
}
[dir='rtl'] .ms-mdPull10[data-v-6af5541f] {
    left: 83.33333%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdPull9[data-v-6af5541f] {
    right: 75%;
}
[dir='rtl'] .ms-mdPull9[data-v-6af5541f] {
    left: 75%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdPull8[data-v-6af5541f] {
    right: 66.66667%;
}
[dir='rtl'] .ms-mdPull8[data-v-6af5541f] {
    left: 66.66667%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdPull7[data-v-6af5541f] {
    right: 58.33333%;
}
[dir='rtl'] .ms-mdPull7[data-v-6af5541f] {
    left: 58.33333%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdPull6[data-v-6af5541f] {
    right: 50%;
}
[dir='rtl'] .ms-mdPull6[data-v-6af5541f] {
    left: 50%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdPull5[data-v-6af5541f] {
    right: 41.66667%;
}
[dir='rtl'] .ms-mdPull5[data-v-6af5541f] {
    left: 41.66667%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdPull4[data-v-6af5541f] {
    right: 33.33333%;
}
[dir='rtl'] .ms-mdPull4[data-v-6af5541f] {
    left: 33.33333%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdPull3[data-v-6af5541f] {
    right: 25%;
}
[dir='rtl'] .ms-mdPull3[data-v-6af5541f] {
    left: 25%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdPull2[data-v-6af5541f] {
    right: 16.66667%;
}
[dir='rtl'] .ms-mdPull2[data-v-6af5541f] {
    left: 16.66667%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdPull1[data-v-6af5541f] {
    right: 8.33333%;
}
[dir='rtl'] .ms-mdPull1[data-v-6af5541f] {
    left: 8.33333%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdPull0[data-v-6af5541f] {
    right: auto;
}
[dir='rtl'] .ms-mdPull0[data-v-6af5541f] {
    left: auto;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdPush12[data-v-6af5541f] {
    left: 100%;
}
[dir='rtl'] .ms-mdPush12[data-v-6af5541f] {
    right: 100%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdPush11[data-v-6af5541f] {
    left: 91.66667%;
}
[dir='rtl'] .ms-mdPush11[data-v-6af5541f] {
    right: 91.66667%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdPush10[data-v-6af5541f] {
    left: 83.33333%;
}
[dir='rtl'] .ms-mdPush10[data-v-6af5541f] {
    right: 83.33333%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdPush9[data-v-6af5541f] {
    left: 75%;
}
[dir='rtl'] .ms-mdPush9[data-v-6af5541f] {
    right: 75%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdPush8[data-v-6af5541f] {
    left: 66.66667%;
}
[dir='rtl'] .ms-mdPush8[data-v-6af5541f] {
    right: 66.66667%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdPush7[data-v-6af5541f] {
    left: 58.33333%;
}
[dir='rtl'] .ms-mdPush7[data-v-6af5541f] {
    right: 58.33333%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdPush6[data-v-6af5541f] {
    left: 50%;
}
[dir='rtl'] .ms-mdPush6[data-v-6af5541f] {
    right: 50%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdPush5[data-v-6af5541f] {
    left: 41.66667%;
}
[dir='rtl'] .ms-mdPush5[data-v-6af5541f] {
    right: 41.66667%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdPush4[data-v-6af5541f] {
    left: 33.33333%;
}
[dir='rtl'] .ms-mdPush4[data-v-6af5541f] {
    right: 33.33333%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdPush3[data-v-6af5541f] {
    left: 25%;
}
[dir='rtl'] .ms-mdPush3[data-v-6af5541f] {
    right: 25%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdPush2[data-v-6af5541f] {
    left: 16.66667%;
}
[dir='rtl'] .ms-mdPush2[data-v-6af5541f] {
    right: 16.66667%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdPush1[data-v-6af5541f] {
    left: 8.33333%;
}
[dir='rtl'] .ms-mdPush1[data-v-6af5541f] {
    right: 8.33333%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdPush0[data-v-6af5541f] {
    left: auto;
}
[dir='rtl'] .ms-mdPush0[data-v-6af5541f] {
    right: auto;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdOffset11[data-v-6af5541f] {
    margin-left: 91.66667%;
}
[dir='rtl'] .ms-mdOffset11[data-v-6af5541f] {
    margin-right: 91.66667%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdOffset10[data-v-6af5541f] {
    margin-left: 83.33333%;
}
[dir='rtl'] .ms-mdOffset10[data-v-6af5541f] {
    margin-right: 83.33333%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdOffset9[data-v-6af5541f] {
    margin-left: 75%;
}
[dir='rtl'] .ms-mdOffset9[data-v-6af5541f] {
    margin-right: 75%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdOffset8[data-v-6af5541f] {
    margin-left: 66.66667%;
}
[dir='rtl'] .ms-mdOffset8[data-v-6af5541f] {
    margin-right: 66.66667%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdOffset7[data-v-6af5541f] {
    margin-left: 58.33333%;
}
[dir='rtl'] .ms-mdOffset7[data-v-6af5541f] {
    margin-right: 58.33333%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdOffset6[data-v-6af5541f] {
    margin-left: 50%;
}
[dir='rtl'] .ms-mdOffset6[data-v-6af5541f] {
    margin-right: 50%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdOffset5[data-v-6af5541f] {
    margin-left: 41.66667%;
}
[dir='rtl'] .ms-mdOffset5[data-v-6af5541f] {
    margin-right: 41.66667%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdOffset4[data-v-6af5541f] {
    margin-left: 33.33333%;
}
[dir='rtl'] .ms-mdOffset4[data-v-6af5541f] {
    margin-right: 33.33333%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdOffset3[data-v-6af5541f] {
    margin-left: 25%;
}
[dir='rtl'] .ms-mdOffset3[data-v-6af5541f] {
    margin-right: 25%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdOffset2[data-v-6af5541f] {
    margin-left: 16.66667%;
}
[dir='rtl'] .ms-mdOffset2[data-v-6af5541f] {
    margin-right: 16.66667%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdOffset1[data-v-6af5541f] {
    margin-left: 8.33333%;
}
[dir='rtl'] .ms-mdOffset1[data-v-6af5541f] {
    margin-right: 8.33333%;
}
}
@media (min-width: 480px) {
[dir='ltr'] .ms-mdOffset0[data-v-6af5541f] {
    margin-left: 0;
}
[dir='rtl'] .ms-mdOffset0[data-v-6af5541f] {
    margin-right: 0;
}
}
@media (min-width: 640px) {
.ms-lg12[data-v-6af5541f] {
    width: 100%;
}
}
@media (min-width: 640px) {
.ms-lg11[data-v-6af5541f] {
    width: 91.66666666666666%;
}
}
@media (min-width: 640px) {
.ms-lg10[data-v-6af5541f] {
    width: 83.33333333333334%;
}
}
@media (min-width: 640px) {
.ms-lg9[data-v-6af5541f] {
    width: 75%;
}
}
@media (min-width: 640px) {
.ms-lg8[data-v-6af5541f] {
    width: 66.66666666666666%;
}
}
@media (min-width: 640px) {
.ms-lg7[data-v-6af5541f] {
    width: 58.333333333333336%;
}
}
@media (min-width: 640px) {
.ms-lg6[data-v-6af5541f] {
    width: 50%;
}
}
@media (min-width: 640px) {
.ms-lg5[data-v-6af5541f] {
    width: 41.66666666666667%;
}
}
@media (min-width: 640px) {
.ms-lg4[data-v-6af5541f] {
    width: 33.33333333333333%;
}
}
@media (min-width: 640px) {
.ms-lg3[data-v-6af5541f] {
    width: 25%;
}
}
@media (min-width: 640px) {
.ms-lg2[data-v-6af5541f] {
    width: 16.666666666666664%;
}
}
@media (min-width: 640px) {
.ms-lg1[data-v-6af5541f] {
    width: 8.333333333333332%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgPull12[data-v-6af5541f] {
    right: 100%;
}
[dir='rtl'] .ms-lgPull12[data-v-6af5541f] {
    left: 100%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgPull11[data-v-6af5541f] {
    right: 91.66667%;
}
[dir='rtl'] .ms-lgPull11[data-v-6af5541f] {
    left: 91.66667%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgPull10[data-v-6af5541f] {
    right: 83.33333%;
}
[dir='rtl'] .ms-lgPull10[data-v-6af5541f] {
    left: 83.33333%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgPull9[data-v-6af5541f] {
    right: 75%;
}
[dir='rtl'] .ms-lgPull9[data-v-6af5541f] {
    left: 75%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgPull8[data-v-6af5541f] {
    right: 66.66667%;
}
[dir='rtl'] .ms-lgPull8[data-v-6af5541f] {
    left: 66.66667%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgPull7[data-v-6af5541f] {
    right: 58.33333%;
}
[dir='rtl'] .ms-lgPull7[data-v-6af5541f] {
    left: 58.33333%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgPull6[data-v-6af5541f] {
    right: 50%;
}
[dir='rtl'] .ms-lgPull6[data-v-6af5541f] {
    left: 50%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgPull5[data-v-6af5541f] {
    right: 41.66667%;
}
[dir='rtl'] .ms-lgPull5[data-v-6af5541f] {
    left: 41.66667%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgPull4[data-v-6af5541f] {
    right: 33.33333%;
}
[dir='rtl'] .ms-lgPull4[data-v-6af5541f] {
    left: 33.33333%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgPull3[data-v-6af5541f] {
    right: 25%;
}
[dir='rtl'] .ms-lgPull3[data-v-6af5541f] {
    left: 25%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgPull2[data-v-6af5541f] {
    right: 16.66667%;
}
[dir='rtl'] .ms-lgPull2[data-v-6af5541f] {
    left: 16.66667%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgPull1[data-v-6af5541f] {
    right: 8.33333%;
}
[dir='rtl'] .ms-lgPull1[data-v-6af5541f] {
    left: 8.33333%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgPull0[data-v-6af5541f] {
    right: auto;
}
[dir='rtl'] .ms-lgPull0[data-v-6af5541f] {
    left: auto;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgPush12[data-v-6af5541f] {
    left: 100%;
}
[dir='rtl'] .ms-lgPush12[data-v-6af5541f] {
    right: 100%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgPush11[data-v-6af5541f] {
    left: 91.66667%;
}
[dir='rtl'] .ms-lgPush11[data-v-6af5541f] {
    right: 91.66667%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgPush10[data-v-6af5541f] {
    left: 83.33333%;
}
[dir='rtl'] .ms-lgPush10[data-v-6af5541f] {
    right: 83.33333%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgPush9[data-v-6af5541f] {
    left: 75%;
}
[dir='rtl'] .ms-lgPush9[data-v-6af5541f] {
    right: 75%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgPush8[data-v-6af5541f] {
    left: 66.66667%;
}
[dir='rtl'] .ms-lgPush8[data-v-6af5541f] {
    right: 66.66667%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgPush7[data-v-6af5541f] {
    left: 58.33333%;
}
[dir='rtl'] .ms-lgPush7[data-v-6af5541f] {
    right: 58.33333%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgPush6[data-v-6af5541f] {
    left: 50%;
}
[dir='rtl'] .ms-lgPush6[data-v-6af5541f] {
    right: 50%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgPush5[data-v-6af5541f] {
    left: 41.66667%;
}
[dir='rtl'] .ms-lgPush5[data-v-6af5541f] {
    right: 41.66667%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgPush4[data-v-6af5541f] {
    left: 33.33333%;
}
[dir='rtl'] .ms-lgPush4[data-v-6af5541f] {
    right: 33.33333%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgPush3[data-v-6af5541f] {
    left: 25%;
}
[dir='rtl'] .ms-lgPush3[data-v-6af5541f] {
    right: 25%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgPush2[data-v-6af5541f] {
    left: 16.66667%;
}
[dir='rtl'] .ms-lgPush2[data-v-6af5541f] {
    right: 16.66667%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgPush1[data-v-6af5541f] {
    left: 8.33333%;
}
[dir='rtl'] .ms-lgPush1[data-v-6af5541f] {
    right: 8.33333%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgPush0[data-v-6af5541f] {
    left: auto;
}
[dir='rtl'] .ms-lgPush0[data-v-6af5541f] {
    right: auto;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgOffset11[data-v-6af5541f] {
    margin-left: 91.66667%;
}
[dir='rtl'] .ms-lgOffset11[data-v-6af5541f] {
    margin-right: 91.66667%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgOffset10[data-v-6af5541f] {
    margin-left: 83.33333%;
}
[dir='rtl'] .ms-lgOffset10[data-v-6af5541f] {
    margin-right: 83.33333%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgOffset9[data-v-6af5541f] {
    margin-left: 75%;
}
[dir='rtl'] .ms-lgOffset9[data-v-6af5541f] {
    margin-right: 75%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgOffset8[data-v-6af5541f] {
    margin-left: 66.66667%;
}
[dir='rtl'] .ms-lgOffset8[data-v-6af5541f] {
    margin-right: 66.66667%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgOffset7[data-v-6af5541f] {
    margin-left: 58.33333%;
}
[dir='rtl'] .ms-lgOffset7[data-v-6af5541f] {
    margin-right: 58.33333%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgOffset6[data-v-6af5541f] {
    margin-left: 50%;
}
[dir='rtl'] .ms-lgOffset6[data-v-6af5541f] {
    margin-right: 50%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgOffset5[data-v-6af5541f] {
    margin-left: 41.66667%;
}
[dir='rtl'] .ms-lgOffset5[data-v-6af5541f] {
    margin-right: 41.66667%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgOffset4[data-v-6af5541f] {
    margin-left: 33.33333%;
}
[dir='rtl'] .ms-lgOffset4[data-v-6af5541f] {
    margin-right: 33.33333%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgOffset3[data-v-6af5541f] {
    margin-left: 25%;
}
[dir='rtl'] .ms-lgOffset3[data-v-6af5541f] {
    margin-right: 25%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgOffset2[data-v-6af5541f] {
    margin-left: 16.66667%;
}
[dir='rtl'] .ms-lgOffset2[data-v-6af5541f] {
    margin-right: 16.66667%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgOffset1[data-v-6af5541f] {
    margin-left: 8.33333%;
}
[dir='rtl'] .ms-lgOffset1[data-v-6af5541f] {
    margin-right: 8.33333%;
}
}
@media (min-width: 640px) {
[dir='ltr'] .ms-lgOffset0[data-v-6af5541f] {
    margin-left: 0;
}
[dir='rtl'] .ms-lgOffset0[data-v-6af5541f] {
    margin-right: 0;
}
}
@media (min-width: 1024px) {
.ms-xl12[data-v-6af5541f] {
    width: 100%;
}
}
@media (min-width: 1024px) {
.ms-xl11[data-v-6af5541f] {
    width: 91.66666666666666%;
}
}
@media (min-width: 1024px) {
.ms-xl10[data-v-6af5541f] {
    width: 83.33333333333334%;
}
}
@media (min-width: 1024px) {
.ms-xl9[data-v-6af5541f] {
    width: 75%;
}
}
@media (min-width: 1024px) {
.ms-xl8[data-v-6af5541f] {
    width: 66.66666666666666%;
}
}
@media (min-width: 1024px) {
.ms-xl7[data-v-6af5541f] {
    width: 58.333333333333336%;
}
}
@media (min-width: 1024px) {
.ms-xl6[data-v-6af5541f] {
    width: 50%;
}
}
@media (min-width: 1024px) {
.ms-xl5[data-v-6af5541f] {
    width: 41.66666666666667%;
}
}
@media (min-width: 1024px) {
.ms-xl4[data-v-6af5541f] {
    width: 33.33333333333333%;
}
}
@media (min-width: 1024px) {
.ms-xl3[data-v-6af5541f] {
    width: 25%;
}
}
@media (min-width: 1024px) {
.ms-xl2[data-v-6af5541f] {
    width: 16.666666666666664%;
}
}
@media (min-width: 1024px) {
.ms-xl1[data-v-6af5541f] {
    width: 8.333333333333332%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlPull12[data-v-6af5541f] {
    right: 100%;
}
[dir='rtl'] .ms-xlPull12[data-v-6af5541f] {
    left: 100%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlPull11[data-v-6af5541f] {
    right: 91.66667%;
}
[dir='rtl'] .ms-xlPull11[data-v-6af5541f] {
    left: 91.66667%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlPull10[data-v-6af5541f] {
    right: 83.33333%;
}
[dir='rtl'] .ms-xlPull10[data-v-6af5541f] {
    left: 83.33333%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlPull9[data-v-6af5541f] {
    right: 75%;
}
[dir='rtl'] .ms-xlPull9[data-v-6af5541f] {
    left: 75%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlPull8[data-v-6af5541f] {
    right: 66.66667%;
}
[dir='rtl'] .ms-xlPull8[data-v-6af5541f] {
    left: 66.66667%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlPull7[data-v-6af5541f] {
    right: 58.33333%;
}
[dir='rtl'] .ms-xlPull7[data-v-6af5541f] {
    left: 58.33333%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlPull6[data-v-6af5541f] {
    right: 50%;
}
[dir='rtl'] .ms-xlPull6[data-v-6af5541f] {
    left: 50%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlPull5[data-v-6af5541f] {
    right: 41.66667%;
}
[dir='rtl'] .ms-xlPull5[data-v-6af5541f] {
    left: 41.66667%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlPull4[data-v-6af5541f] {
    right: 33.33333%;
}
[dir='rtl'] .ms-xlPull4[data-v-6af5541f] {
    left: 33.33333%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlPull3[data-v-6af5541f] {
    right: 25%;
}
[dir='rtl'] .ms-xlPull3[data-v-6af5541f] {
    left: 25%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlPull2[data-v-6af5541f] {
    right: 16.66667%;
}
[dir='rtl'] .ms-xlPull2[data-v-6af5541f] {
    left: 16.66667%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlPull1[data-v-6af5541f] {
    right: 8.33333%;
}
[dir='rtl'] .ms-xlPull1[data-v-6af5541f] {
    left: 8.33333%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlPull0[data-v-6af5541f] {
    right: auto;
}
[dir='rtl'] .ms-xlPull0[data-v-6af5541f] {
    left: auto;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlPush12[data-v-6af5541f] {
    left: 100%;
}
[dir='rtl'] .ms-xlPush12[data-v-6af5541f] {
    right: 100%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlPush11[data-v-6af5541f] {
    left: 91.66667%;
}
[dir='rtl'] .ms-xlPush11[data-v-6af5541f] {
    right: 91.66667%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlPush10[data-v-6af5541f] {
    left: 83.33333%;
}
[dir='rtl'] .ms-xlPush10[data-v-6af5541f] {
    right: 83.33333%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlPush9[data-v-6af5541f] {
    left: 75%;
}
[dir='rtl'] .ms-xlPush9[data-v-6af5541f] {
    right: 75%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlPush8[data-v-6af5541f] {
    left: 66.66667%;
}
[dir='rtl'] .ms-xlPush8[data-v-6af5541f] {
    right: 66.66667%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlPush7[data-v-6af5541f] {
    left: 58.33333%;
}
[dir='rtl'] .ms-xlPush7[data-v-6af5541f] {
    right: 58.33333%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlPush6[data-v-6af5541f] {
    left: 50%;
}
[dir='rtl'] .ms-xlPush6[data-v-6af5541f] {
    right: 50%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlPush5[data-v-6af5541f] {
    left: 41.66667%;
}
[dir='rtl'] .ms-xlPush5[data-v-6af5541f] {
    right: 41.66667%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlPush4[data-v-6af5541f] {
    left: 33.33333%;
}
[dir='rtl'] .ms-xlPush4[data-v-6af5541f] {
    right: 33.33333%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlPush3[data-v-6af5541f] {
    left: 25%;
}
[dir='rtl'] .ms-xlPush3[data-v-6af5541f] {
    right: 25%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlPush2[data-v-6af5541f] {
    left: 16.66667%;
}
[dir='rtl'] .ms-xlPush2[data-v-6af5541f] {
    right: 16.66667%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlPush1[data-v-6af5541f] {
    left: 8.33333%;
}
[dir='rtl'] .ms-xlPush1[data-v-6af5541f] {
    right: 8.33333%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlPush0[data-v-6af5541f] {
    left: auto;
}
[dir='rtl'] .ms-xlPush0[data-v-6af5541f] {
    right: auto;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlOffset11[data-v-6af5541f] {
    margin-left: 91.66667%;
}
[dir='rtl'] .ms-xlOffset11[data-v-6af5541f] {
    margin-right: 91.66667%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlOffset10[data-v-6af5541f] {
    margin-left: 83.33333%;
}
[dir='rtl'] .ms-xlOffset10[data-v-6af5541f] {
    margin-right: 83.33333%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlOffset9[data-v-6af5541f] {
    margin-left: 75%;
}
[dir='rtl'] .ms-xlOffset9[data-v-6af5541f] {
    margin-right: 75%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlOffset8[data-v-6af5541f] {
    margin-left: 66.66667%;
}
[dir='rtl'] .ms-xlOffset8[data-v-6af5541f] {
    margin-right: 66.66667%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlOffset7[data-v-6af5541f] {
    margin-left: 58.33333%;
}
[dir='rtl'] .ms-xlOffset7[data-v-6af5541f] {
    margin-right: 58.33333%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlOffset6[data-v-6af5541f] {
    margin-left: 50%;
}
[dir='rtl'] .ms-xlOffset6[data-v-6af5541f] {
    margin-right: 50%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlOffset5[data-v-6af5541f] {
    margin-left: 41.66667%;
}
[dir='rtl'] .ms-xlOffset5[data-v-6af5541f] {
    margin-right: 41.66667%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlOffset4[data-v-6af5541f] {
    margin-left: 33.33333%;
}
[dir='rtl'] .ms-xlOffset4[data-v-6af5541f] {
    margin-right: 33.33333%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlOffset3[data-v-6af5541f] {
    margin-left: 25%;
}
[dir='rtl'] .ms-xlOffset3[data-v-6af5541f] {
    margin-right: 25%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlOffset2[data-v-6af5541f] {
    margin-left: 16.66667%;
}
[dir='rtl'] .ms-xlOffset2[data-v-6af5541f] {
    margin-right: 16.66667%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlOffset1[data-v-6af5541f] {
    margin-left: 8.33333%;
}
[dir='rtl'] .ms-xlOffset1[data-v-6af5541f] {
    margin-right: 8.33333%;
}
}
@media (min-width: 1024px) {
[dir='ltr'] .ms-xlOffset0[data-v-6af5541f] {
    margin-left: 0;
}
[dir='rtl'] .ms-xlOffset0[data-v-6af5541f] {
    margin-right: 0;
}
}
@media (min-width: 1366px) {
.ms-xxl12[data-v-6af5541f] {
    width: 100%;
}
}
@media (min-width: 1366px) {
.ms-xxl11[data-v-6af5541f] {
    width: 91.66666666666666%;
}
}
@media (min-width: 1366px) {
.ms-xxl10[data-v-6af5541f] {
    width: 83.33333333333334%;
}
}
@media (min-width: 1366px) {
.ms-xxl9[data-v-6af5541f] {
    width: 75%;
}
}
@media (min-width: 1366px) {
.ms-xxl8[data-v-6af5541f] {
    width: 66.66666666666666%;
}
}
@media (min-width: 1366px) {
.ms-xxl7[data-v-6af5541f] {
    width: 58.333333333333336%;
}
}
@media (min-width: 1366px) {
.ms-xxl6[data-v-6af5541f] {
    width: 50%;
}
}
@media (min-width: 1366px) {
.ms-xxl5[data-v-6af5541f] {
    width: 41.66666666666667%;
}
}
@media (min-width: 1366px) {
.ms-xxl4[data-v-6af5541f] {
    width: 33.33333333333333%;
}
}
@media (min-width: 1366px) {
.ms-xxl3[data-v-6af5541f] {
    width: 25%;
}
}
@media (min-width: 1366px) {
.ms-xxl2[data-v-6af5541f] {
    width: 16.666666666666664%;
}
}
@media (min-width: 1366px) {
.ms-xxl1[data-v-6af5541f] {
    width: 8.333333333333332%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlPull12[data-v-6af5541f] {
    right: 100%;
}
[dir='rtl'] .ms-xxlPull12[data-v-6af5541f] {
    left: 100%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlPull11[data-v-6af5541f] {
    right: 91.66667%;
}
[dir='rtl'] .ms-xxlPull11[data-v-6af5541f] {
    left: 91.66667%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlPull10[data-v-6af5541f] {
    right: 83.33333%;
}
[dir='rtl'] .ms-xxlPull10[data-v-6af5541f] {
    left: 83.33333%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlPull9[data-v-6af5541f] {
    right: 75%;
}
[dir='rtl'] .ms-xxlPull9[data-v-6af5541f] {
    left: 75%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlPull8[data-v-6af5541f] {
    right: 66.66667%;
}
[dir='rtl'] .ms-xxlPull8[data-v-6af5541f] {
    left: 66.66667%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlPull7[data-v-6af5541f] {
    right: 58.33333%;
}
[dir='rtl'] .ms-xxlPull7[data-v-6af5541f] {
    left: 58.33333%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlPull6[data-v-6af5541f] {
    right: 50%;
}
[dir='rtl'] .ms-xxlPull6[data-v-6af5541f] {
    left: 50%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlPull5[data-v-6af5541f] {
    right: 41.66667%;
}
[dir='rtl'] .ms-xxlPull5[data-v-6af5541f] {
    left: 41.66667%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlPull4[data-v-6af5541f] {
    right: 33.33333%;
}
[dir='rtl'] .ms-xxlPull4[data-v-6af5541f] {
    left: 33.33333%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlPull3[data-v-6af5541f] {
    right: 25%;
}
[dir='rtl'] .ms-xxlPull3[data-v-6af5541f] {
    left: 25%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlPull2[data-v-6af5541f] {
    right: 16.66667%;
}
[dir='rtl'] .ms-xxlPull2[data-v-6af5541f] {
    left: 16.66667%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlPull1[data-v-6af5541f] {
    right: 8.33333%;
}
[dir='rtl'] .ms-xxlPull1[data-v-6af5541f] {
    left: 8.33333%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlPull0[data-v-6af5541f] {
    right: auto;
}
[dir='rtl'] .ms-xxlPull0[data-v-6af5541f] {
    left: auto;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlPush12[data-v-6af5541f] {
    left: 100%;
}
[dir='rtl'] .ms-xxlPush12[data-v-6af5541f] {
    right: 100%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlPush11[data-v-6af5541f] {
    left: 91.66667%;
}
[dir='rtl'] .ms-xxlPush11[data-v-6af5541f] {
    right: 91.66667%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlPush10[data-v-6af5541f] {
    left: 83.33333%;
}
[dir='rtl'] .ms-xxlPush10[data-v-6af5541f] {
    right: 83.33333%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlPush9[data-v-6af5541f] {
    left: 75%;
}
[dir='rtl'] .ms-xxlPush9[data-v-6af5541f] {
    right: 75%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlPush8[data-v-6af5541f] {
    left: 66.66667%;
}
[dir='rtl'] .ms-xxlPush8[data-v-6af5541f] {
    right: 66.66667%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlPush7[data-v-6af5541f] {
    left: 58.33333%;
}
[dir='rtl'] .ms-xxlPush7[data-v-6af5541f] {
    right: 58.33333%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlPush6[data-v-6af5541f] {
    left: 50%;
}
[dir='rtl'] .ms-xxlPush6[data-v-6af5541f] {
    right: 50%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlPush5[data-v-6af5541f] {
    left: 41.66667%;
}
[dir='rtl'] .ms-xxlPush5[data-v-6af5541f] {
    right: 41.66667%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlPush4[data-v-6af5541f] {
    left: 33.33333%;
}
[dir='rtl'] .ms-xxlPush4[data-v-6af5541f] {
    right: 33.33333%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlPush3[data-v-6af5541f] {
    left: 25%;
}
[dir='rtl'] .ms-xxlPush3[data-v-6af5541f] {
    right: 25%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlPush2[data-v-6af5541f] {
    left: 16.66667%;
}
[dir='rtl'] .ms-xxlPush2[data-v-6af5541f] {
    right: 16.66667%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlPush1[data-v-6af5541f] {
    left: 8.33333%;
}
[dir='rtl'] .ms-xxlPush1[data-v-6af5541f] {
    right: 8.33333%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlPush0[data-v-6af5541f] {
    left: auto;
}
[dir='rtl'] .ms-xxlPush0[data-v-6af5541f] {
    right: auto;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlOffset11[data-v-6af5541f] {
    margin-left: 91.66667%;
}
[dir='rtl'] .ms-xxlOffset11[data-v-6af5541f] {
    margin-right: 91.66667%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlOffset10[data-v-6af5541f] {
    margin-left: 83.33333%;
}
[dir='rtl'] .ms-xxlOffset10[data-v-6af5541f] {
    margin-right: 83.33333%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlOffset9[data-v-6af5541f] {
    margin-left: 75%;
}
[dir='rtl'] .ms-xxlOffset9[data-v-6af5541f] {
    margin-right: 75%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlOffset8[data-v-6af5541f] {
    margin-left: 66.66667%;
}
[dir='rtl'] .ms-xxlOffset8[data-v-6af5541f] {
    margin-right: 66.66667%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlOffset7[data-v-6af5541f] {
    margin-left: 58.33333%;
}
[dir='rtl'] .ms-xxlOffset7[data-v-6af5541f] {
    margin-right: 58.33333%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlOffset6[data-v-6af5541f] {
    margin-left: 50%;
}
[dir='rtl'] .ms-xxlOffset6[data-v-6af5541f] {
    margin-right: 50%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlOffset5[data-v-6af5541f] {
    margin-left: 41.66667%;
}
[dir='rtl'] .ms-xxlOffset5[data-v-6af5541f] {
    margin-right: 41.66667%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlOffset4[data-v-6af5541f] {
    margin-left: 33.33333%;
}
[dir='rtl'] .ms-xxlOffset4[data-v-6af5541f] {
    margin-right: 33.33333%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlOffset3[data-v-6af5541f] {
    margin-left: 25%;
}
[dir='rtl'] .ms-xxlOffset3[data-v-6af5541f] {
    margin-right: 25%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlOffset2[data-v-6af5541f] {
    margin-left: 16.66667%;
}
[dir='rtl'] .ms-xxlOffset2[data-v-6af5541f] {
    margin-right: 16.66667%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlOffset1[data-v-6af5541f] {
    margin-left: 8.33333%;
}
[dir='rtl'] .ms-xxlOffset1[data-v-6af5541f] {
    margin-right: 8.33333%;
}
}
@media (min-width: 1366px) {
[dir='ltr'] .ms-xxlOffset0[data-v-6af5541f] {
    margin-left: 0;
}
[dir='rtl'] .ms-xxlOffset0[data-v-6af5541f] {
    margin-right: 0;
}
}
@media (min-width: 1920px) {
.ms-xxxl12[data-v-6af5541f] {
    width: 100%;
}
}
@media (min-width: 1920px) {
.ms-xxxl11[data-v-6af5541f] {
    width: 91.66666666666666%;
}
}
@media (min-width: 1920px) {
.ms-xxxl10[data-v-6af5541f] {
    width: 83.33333333333334%;
}
}
@media (min-width: 1920px) {
.ms-xxxl9[data-v-6af5541f] {
    width: 75%;
}
}
@media (min-width: 1920px) {
.ms-xxxl8[data-v-6af5541f] {
    width: 66.66666666666666%;
}
}
@media (min-width: 1920px) {
.ms-xxxl7[data-v-6af5541f] {
    width: 58.333333333333336%;
}
}
@media (min-width: 1920px) {
.ms-xxxl6[data-v-6af5541f] {
    width: 50%;
}
}
@media (min-width: 1920px) {
.ms-xxxl5[data-v-6af5541f] {
    width: 41.66666666666667%;
}
}
@media (min-width: 1920px) {
.ms-xxxl4[data-v-6af5541f] {
    width: 33.33333333333333%;
}
}
@media (min-width: 1920px) {
.ms-xxxl3[data-v-6af5541f] {
    width: 25%;
}
}
@media (min-width: 1920px) {
.ms-xxxl2[data-v-6af5541f] {
    width: 16.666666666666664%;
}
}
@media (min-width: 1920px) {
.ms-xxxl1[data-v-6af5541f] {
    width: 8.333333333333332%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlPull12[data-v-6af5541f] {
    right: 100%;
}
[dir='rtl'] .ms-xxxlPull12[data-v-6af5541f] {
    left: 100%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlPull11[data-v-6af5541f] {
    right: 91.66667%;
}
[dir='rtl'] .ms-xxxlPull11[data-v-6af5541f] {
    left: 91.66667%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlPull10[data-v-6af5541f] {
    right: 83.33333%;
}
[dir='rtl'] .ms-xxxlPull10[data-v-6af5541f] {
    left: 83.33333%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlPull9[data-v-6af5541f] {
    right: 75%;
}
[dir='rtl'] .ms-xxxlPull9[data-v-6af5541f] {
    left: 75%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlPull8[data-v-6af5541f] {
    right: 66.66667%;
}
[dir='rtl'] .ms-xxxlPull8[data-v-6af5541f] {
    left: 66.66667%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlPull7[data-v-6af5541f] {
    right: 58.33333%;
}
[dir='rtl'] .ms-xxxlPull7[data-v-6af5541f] {
    left: 58.33333%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlPull6[data-v-6af5541f] {
    right: 50%;
}
[dir='rtl'] .ms-xxxlPull6[data-v-6af5541f] {
    left: 50%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlPull5[data-v-6af5541f] {
    right: 41.66667%;
}
[dir='rtl'] .ms-xxxlPull5[data-v-6af5541f] {
    left: 41.66667%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlPull4[data-v-6af5541f] {
    right: 33.33333%;
}
[dir='rtl'] .ms-xxxlPull4[data-v-6af5541f] {
    left: 33.33333%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlPull3[data-v-6af5541f] {
    right: 25%;
}
[dir='rtl'] .ms-xxxlPull3[data-v-6af5541f] {
    left: 25%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlPull2[data-v-6af5541f] {
    right: 16.66667%;
}
[dir='rtl'] .ms-xxxlPull2[data-v-6af5541f] {
    left: 16.66667%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlPull1[data-v-6af5541f] {
    right: 8.33333%;
}
[dir='rtl'] .ms-xxxlPull1[data-v-6af5541f] {
    left: 8.33333%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlPull0[data-v-6af5541f] {
    right: auto;
}
[dir='rtl'] .ms-xxxlPull0[data-v-6af5541f] {
    left: auto;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlPush12[data-v-6af5541f] {
    left: 100%;
}
[dir='rtl'] .ms-xxxlPush12[data-v-6af5541f] {
    right: 100%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlPush11[data-v-6af5541f] {
    left: 91.66667%;
}
[dir='rtl'] .ms-xxxlPush11[data-v-6af5541f] {
    right: 91.66667%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlPush10[data-v-6af5541f] {
    left: 83.33333%;
}
[dir='rtl'] .ms-xxxlPush10[data-v-6af5541f] {
    right: 83.33333%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlPush9[data-v-6af5541f] {
    left: 75%;
}
[dir='rtl'] .ms-xxxlPush9[data-v-6af5541f] {
    right: 75%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlPush8[data-v-6af5541f] {
    left: 66.66667%;
}
[dir='rtl'] .ms-xxxlPush8[data-v-6af5541f] {
    right: 66.66667%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlPush7[data-v-6af5541f] {
    left: 58.33333%;
}
[dir='rtl'] .ms-xxxlPush7[data-v-6af5541f] {
    right: 58.33333%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlPush6[data-v-6af5541f] {
    left: 50%;
}
[dir='rtl'] .ms-xxxlPush6[data-v-6af5541f] {
    right: 50%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlPush5[data-v-6af5541f] {
    left: 41.66667%;
}
[dir='rtl'] .ms-xxxlPush5[data-v-6af5541f] {
    right: 41.66667%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlPush4[data-v-6af5541f] {
    left: 33.33333%;
}
[dir='rtl'] .ms-xxxlPush4[data-v-6af5541f] {
    right: 33.33333%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlPush3[data-v-6af5541f] {
    left: 25%;
}
[dir='rtl'] .ms-xxxlPush3[data-v-6af5541f] {
    right: 25%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlPush2[data-v-6af5541f] {
    left: 16.66667%;
}
[dir='rtl'] .ms-xxxlPush2[data-v-6af5541f] {
    right: 16.66667%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlPush1[data-v-6af5541f] {
    left: 8.33333%;
}
[dir='rtl'] .ms-xxxlPush1[data-v-6af5541f] {
    right: 8.33333%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlPush0[data-v-6af5541f] {
    left: auto;
}
[dir='rtl'] .ms-xxxlPush0[data-v-6af5541f] {
    right: auto;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlOffset11[data-v-6af5541f] {
    margin-left: 91.66667%;
}
[dir='rtl'] .ms-xxxlOffset11[data-v-6af5541f] {
    margin-right: 91.66667%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlOffset10[data-v-6af5541f] {
    margin-left: 83.33333%;
}
[dir='rtl'] .ms-xxxlOffset10[data-v-6af5541f] {
    margin-right: 83.33333%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlOffset9[data-v-6af5541f] {
    margin-left: 75%;
}
[dir='rtl'] .ms-xxxlOffset9[data-v-6af5541f] {
    margin-right: 75%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlOffset8[data-v-6af5541f] {
    margin-left: 66.66667%;
}
[dir='rtl'] .ms-xxxlOffset8[data-v-6af5541f] {
    margin-right: 66.66667%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlOffset7[data-v-6af5541f] {
    margin-left: 58.33333%;
}
[dir='rtl'] .ms-xxxlOffset7[data-v-6af5541f] {
    margin-right: 58.33333%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlOffset6[data-v-6af5541f] {
    margin-left: 50%;
}
[dir='rtl'] .ms-xxxlOffset6[data-v-6af5541f] {
    margin-right: 50%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlOffset5[data-v-6af5541f] {
    margin-left: 41.66667%;
}
[dir='rtl'] .ms-xxxlOffset5[data-v-6af5541f] {
    margin-right: 41.66667%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlOffset4[data-v-6af5541f] {
    margin-left: 33.33333%;
}
[dir='rtl'] .ms-xxxlOffset4[data-v-6af5541f] {
    margin-right: 33.33333%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlOffset3[data-v-6af5541f] {
    margin-left: 25%;
}
[dir='rtl'] .ms-xxxlOffset3[data-v-6af5541f] {
    margin-right: 25%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlOffset2[data-v-6af5541f] {
    margin-left: 16.66667%;
}
[dir='rtl'] .ms-xxxlOffset2[data-v-6af5541f] {
    margin-right: 16.66667%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlOffset1[data-v-6af5541f] {
    margin-left: 8.33333%;
}
[dir='rtl'] .ms-xxxlOffset1[data-v-6af5541f] {
    margin-right: 8.33333%;
}
}
@media (min-width: 1920px) {
[dir='ltr'] .ms-xxxlOffset0[data-v-6af5541f] {
    margin-left: 0;
}
[dir='rtl'] .ms-xxxlOffset0[data-v-6af5541f] {
    margin-right: 0;
}
}
.ms-borderBox[data-v-6af5541f], .ms-borderBox[data-v-6af5541f]::before, .ms-borderBox[data-v-6af5541f]::after {
  box-sizing: border-box;
}
.ms-borderBase[data-v-6af5541f] {
  border: 1px solid;
}
.ms-clearfix[data-v-6af5541f] {
  *zoom: 1;
}
.ms-clearfix[data-v-6af5541f]::before, .ms-clearfix[data-v-6af5541f]::after {
    display: table;
    content: '';
    line-height: 0;
}
.ms-clearfix[data-v-6af5541f]::after {
    clear: both;
}
.ms-normalize[data-v-6af5541f] {
  box-sizing: border-box;
  box-shadow: none;
  margin: 0;
  padding: 0;
}
[dir='ltr'] .ms-textAlignLeft[data-v-6af5541f] {
  text-align: left;
}
[dir='rtl'] .ms-textAlignLeft[data-v-6af5541f] {
  text-align: right;
}
[dir='ltr'] .ms-textAlignRight[data-v-6af5541f] {
  text-align: right;
}
[dir='rtl'] .ms-textAlignRight[data-v-6af5541f] {
  text-align: left;
}
.ms-textAlignCenter[data-v-6af5541f] {
  text-align: center;
}
.ms-screenReaderOnly[data-v-6af5541f] {
  position: absolute;
  width: 1px;
  height: 1px;
  padding: 0;
  margin: -1px;
  overflow: hidden;
  clip: rect(0, 0, 0, 0);
  border: 0;
}
.ms-textTruncate[data-v-6af5541f] {
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
  word-wrap: normal;
}
.ms-noWrap[data-v-6af5541f] {
  white-space: nowrap;
}
.ms-Fabric[data-v-6af5541f] {
  -moz-osx-font-smoothing: grayscale;
  -webkit-font-smoothing: antialiased;
  color: "[theme:neutralPrimary, default: #333333]";
  font-family: "Segoe UI Web (West European)", "Segoe UI", -apple-system, BlinkMacSystemFont, "Roboto", "Helvetica Neue", sans-serif;
  font-size: 14px;
}
.ms-Fabric button[data-v-6af5541f],
  .ms-Fabric input[data-v-6af5541f],
  .ms-Fabric textarea[data-v-6af5541f] {
    font-family: inherit;
}
*[lang^="ar"] .ms-Fabric[data-v-6af5541f],
.ms-Fabric *[lang^="ar"][data-v-6af5541f],
.ms-Fabric[lang^="ar"][data-v-6af5541f] {
  font-family: "Segoe UI Web (Arabic)", "Segoe UI", -apple-system, BlinkMacSystemFont, "Roboto", "Helvetica Neue", sans-serif;
}
*[lang^="bg"] .ms-Fabric[data-v-6af5541f],
.ms-Fabric *[lang^="bg"][data-v-6af5541f],
.ms-Fabric[lang^="bg"][data-v-6af5541f] {
  font-family: "Segoe UI Web (Cyrillic)", "Segoe UI", -apple-system, BlinkMacSystemFont, "Roboto", "Helvetica Neue", sans-serif;
}
*[lang^="cs"] .ms-Fabric[data-v-6af5541f],
.ms-Fabric *[lang^="cs"][data-v-6af5541f],
.ms-Fabric[lang^="cs"][data-v-6af5541f] {
  font-family: "Segoe UI Web (East European)", "Segoe UI", -apple-system, BlinkMacSystemFont, "Roboto", "Helvetica Neue", sans-serif;
}
*[lang^="el"] .ms-Fabric[data-v-6af5541f],
.ms-Fabric *[lang^="el"][data-v-6af5541f],
.ms-Fabric[lang^="el"][data-v-6af5541f] {
  font-family: "Segoe UI Web (Greek)", "Segoe UI", -apple-system, BlinkMacSystemFont, "Roboto", "Helvetica Neue", sans-serif;
}
*[lang^="et"] .ms-Fabric[data-v-6af5541f],
.ms-Fabric *[lang^="et"][data-v-6af5541f],
.ms-Fabric[lang^="et"][data-v-6af5541f] {
  font-family: "Segoe UI Web (East European)", "Segoe UI", -apple-system, BlinkMacSystemFont, "Roboto", "Helvetica Neue", sans-serif;
}
*[lang^="he"] .ms-Fabric[data-v-6af5541f],
.ms-Fabric *[lang^="he"][data-v-6af5541f],
.ms-Fabric[lang^="he"][data-v-6af5541f] {
  font-family: "Segoe UI Web (Hebrew)", "Segoe UI", -apple-system, BlinkMacSystemFont, "Roboto", "Helvetica Neue", sans-serif;
}
*[lang^="hi"] .ms-Fabric[data-v-6af5541f],
.ms-Fabric *[lang^="hi"][data-v-6af5541f],
.ms-Fabric[lang^="hi"][data-v-6af5541f] {
  font-family: "Nirmala UI", "Segoe UI", -apple-system, BlinkMacSystemFont, "Roboto", "Helvetica Neue", sans-serif;
}
*[lang^="hr"] .ms-Fabric[data-v-6af5541f],
.ms-Fabric *[lang^="hr"][data-v-6af5541f],
.ms-Fabric[lang^="hr"][data-v-6af5541f] {
  font-family: "Segoe UI Web (East European)", "Segoe UI", -apple-system, BlinkMacSystemFont, "Roboto", "Helvetica Neue", sans-serif;
}
*[lang^="hu"] .ms-Fabric[data-v-6af5541f],
.ms-Fabric *[lang^="hu"][data-v-6af5541f],
.ms-Fabric[lang^="hu"][data-v-6af5541f] {
  font-family: "Segoe UI Web (East European)", "Segoe UI", -apple-system, BlinkMacSystemFont, "Roboto", "Helvetica Neue", sans-serif;
}
*[lang^="ja"] .ms-Fabric[data-v-6af5541f],
.ms-Fabric *[lang^="ja"][data-v-6af5541f],
.ms-Fabric[lang^="ja"][data-v-6af5541f] {
  font-family: "Yu Gothic UI", "Meiryo UI", Meiryo, "MS Pgothic", Osaka, "Segoe UI", -apple-system, BlinkMacSystemFont, "Roboto", "Helvetica Neue", sans-serif;
}
*[lang^="kk"] .ms-Fabric[data-v-6af5541f],
.ms-Fabric *[lang^="kk"][data-v-6af5541f],
.ms-Fabric[lang^="kk"][data-v-6af5541f] {
  font-family: "Segoe UI Web (East European)", "Segoe UI", -apple-system, BlinkMacSystemFont, "Roboto", "Helvetica Neue", sans-serif;
}
*[lang^="ko"] .ms-Fabric[data-v-6af5541f],
.ms-Fabric *[lang^="ko"][data-v-6af5541f],
.ms-Fabric[lang^="ko"][data-v-6af5541f] {
  font-family: "Malgun Gothic", Gulim, "Segoe UI", -apple-system, BlinkMacSystemFont, "Roboto", "Helvetica Neue", sans-serif;
}
*[lang^="lo"] .ms-Fabric[data-v-6af5541f],
.ms-Fabric *[lang^="lo"][data-v-6af5541f],
.ms-Fabric[lang^="lo"][data-v-6af5541f] {
  font-family: "Leelawadee UI Web", "Lao UI", DokChampa, "Segoe UI", -apple-system, BlinkMacSystemFont, "Roboto", "Helvetica Neue", sans-serif;
}
*[lang^="lt"] .ms-Fabric[data-v-6af5541f],
.ms-Fabric *[lang^="lt"][data-v-6af5541f],
.ms-Fabric[lang^="lt"][data-v-6af5541f] {
  font-family: "Segoe UI Web (East European)", "Segoe UI", -apple-system, BlinkMacSystemFont, "Roboto", "Helvetica Neue", sans-serif;
}
*[lang^="lv"] .ms-Fabric[data-v-6af5541f],
.ms-Fabric *[lang^="lv"][data-v-6af5541f],
.ms-Fabric[lang^="lv"][data-v-6af5541f] {
  font-family: "Segoe UI Web (East European)", "Segoe UI", -apple-system, BlinkMacSystemFont, "Roboto", "Helvetica Neue", sans-serif;
}
*[lang^="pl"] .ms-Fabric[data-v-6af5541f],
.ms-Fabric *[lang^="pl"][data-v-6af5541f],
.ms-Fabric[lang^="pl"][data-v-6af5541f] {
  font-family: "Segoe UI Web (East European)", "Segoe UI", -apple-system, BlinkMacSystemFont, "Roboto", "Helvetica Neue", sans-serif;
}
*[lang^="ru"] .ms-Fabric[data-v-6af5541f],
.ms-Fabric *[lang^="ru"][data-v-6af5541f],
.ms-Fabric[lang^="ru"][data-v-6af5541f] {
  font-family: "Segoe UI Web (Cyrillic)", "Segoe UI", -apple-system, BlinkMacSystemFont, "Roboto", "Helvetica Neue", sans-serif;
}
*[lang^="sk"] .ms-Fabric[data-v-6af5541f],
.ms-Fabric *[lang^="sk"][data-v-6af5541f],
.ms-Fabric[lang^="sk"][data-v-6af5541f] {
  font-family: "Segoe UI Web (East European)", "Segoe UI", -apple-system, BlinkMacSystemFont, "Roboto", "Helvetica Neue", sans-serif;
}
*[lang^="sr-latn"] .ms-Fabric[data-v-6af5541f],
.ms-Fabric *[lang^="sr-latn"][data-v-6af5541f],
.ms-Fabric[lang^="sr-latn"][data-v-6af5541f] {
  font-family: "Segoe UI Web (East European)", "Segoe UI", -apple-system, BlinkMacSystemFont, "Roboto", "Helvetica Neue", sans-serif;
}
*[lang^="th"] .ms-Fabric[data-v-6af5541f],
.ms-Fabric *[lang^="th"][data-v-6af5541f],
.ms-Fabric[lang^="th"][data-v-6af5541f] {
  font-family: "Leelawadee UI Web", "Kmer UI", "Segoe UI", -apple-system, BlinkMacSystemFont, "Roboto", "Helvetica Neue", sans-serif;
}
*[lang^="tr"] .ms-Fabric[data-v-6af5541f],
.ms-Fabric *[lang^="tr"][data-v-6af5541f],
.ms-Fabric[lang^="tr"][data-v-6af5541f] {
  font-family: "Segoe UI Web (East European)", "Segoe UI", -apple-system, BlinkMacSystemFont, "Roboto", "Helvetica Neue", sans-serif;
}
*[lang^="uk"] .ms-Fabric[data-v-6af5541f],
.ms-Fabric *[lang^="uk"][data-v-6af5541f],
.ms-Fabric[lang^="uk"][data-v-6af5541f] {
  font-family: "Segoe UI Web (Cyrillic)", "Segoe UI", -apple-system, BlinkMacSystemFont, "Roboto", "Helvetica Neue", sans-serif;
}
*[lang^="vi"] .ms-Fabric[data-v-6af5541f],
.ms-Fabric *[lang^="vi"][data-v-6af5541f],
.ms-Fabric[lang^="vi"][data-v-6af5541f] {
  font-family: "Segoe UI Web (Vietnamese)", "Segoe UI", -apple-system, BlinkMacSystemFont, "Roboto", "Helvetica Neue", sans-serif;
}
*[lang^="zh-hans"] .ms-Fabric[data-v-6af5541f],
.ms-Fabric *[lang^="zh-hans"][data-v-6af5541f],
.ms-Fabric[lang^="zh-hans"][data-v-6af5541f] {
  font-family: "Microsoft Yahei UI", Verdana, Simsun, "Segoe UI", -apple-system, BlinkMacSystemFont, "Roboto", "Helvetica Neue", sans-serif;
}
*[lang^="zh-hant"] .ms-Fabric[data-v-6af5541f],
.ms-Fabric *[lang^="zh-hant"][data-v-6af5541f],
.ms-Fabric[lang^="zh-hant"][data-v-6af5541f] {
  font-family: "Microsoft Jhenghei UI", Pmingliu, "Segoe UI", -apple-system, BlinkMacSystemFont, "Roboto", "Helvetica Neue", sans-serif;
}
.ms-Fabric--selawik[data-v-6af5541f] {
  font-family: "Selawik Web", "Segoe UI", -apple-system, BlinkMacSystemFont, "Roboto", "Helvetica Neue", sans-serif;
}
.header-container[data-v-6af5541f] {
  padding: 8px 8px;
  color: "[theme:bodyText, default:#333]";
  border-bottom: 1px solid "[theme:neutralLight, default:#eaeaea]";
}
.header-table[data-v-6af5541f] {
  font-weight: 600;
}
.line-height-modifier[data-v-6af5541f] {
  margin: 4px 0 4px 0;
}
@media (max-width: 478px) {
.xxs-hidden[data-v-6af5541f] {
    display: none;
}
[class*="ms-md"][data-v-6af5541f] {
    width: 100%;
}
}
a[data-v-6af5541f] {
  text-decoration: none;
  color: "[theme:bodyText, default:#333]";
}
div.content-table[data-v-6af5541f] {
  color: "[theme:bodyText, default:#333]";
  border-bottom: 1px solid "[theme:neutralLight, default:#eaeaea]";
  padding: 8px 8px;
}
div.content-table[data-v-6af5541f]:hover {
    background-color: "[theme:neutralLighterAlt, default:#f8f8f8]";
}
div.content-table .word-break[data-v-6af5541f] {
    word-break: break-word;
}
.pagination[data-v-6af5541f] {
  margin: 16px 0;
}


`;

    return component;

});
